-- --------------------------------------------------------------------------
-- Copyright  2008 PlayFirst, Inc. All Rights Reserved.
--
-- This material is the confidential trade secret and proprietary
-- information of PlayFirst, Inc. It may not be reproduced, used, disclosed,
-- sold or transferred without the prior written consent of PlayFirst, Inc. 
-- All rights reserved.
-- --------------------------------------------------------------------------
require( "scripts/style.lua" );

kTitleY			= 50;
kFirstButtonY	= kCenter;
kButtonSpaceX	= 80;
kTextButton		= 30;

function DifficultSelected()
	if(GetCurrentGameMode() == 8 or 
		GetCurrentGameMode() == 1 or
		GetCurrentGameMode() == 2 or
		GetCurrentGameMode() == 3
		)then			--Fitness Mode
		if(GetDifficultyLevel() == 0)then
			SetCurrentGameMode(eFitnessEasy);		
		elseif(GetDifficultyLevel() == 1)then
			SetCurrentGameMode(eFitnessMedium);		
		elseif(GetDifficultyLevel() == 2)then
			SetCurrentGameMode(eFitnessHard);		
		end
		-- PopModal("levelselector");
		PlayButton();
	end
	if(GetCurrentGameMode() == 9) then		--Tug of War	
		if(GetDifficultyLevel() == 0)then
			SetCurrentGameMode(eTugEasy);		
		elseif(GetDifficultyLevel() == 1)then
			SetCurrentGameMode(eTugMedium);		
		elseif(GetDifficultyLevel() == 2)then
			SetCurrentGameMode(eTugHard);		
		end
		PlayButton();
	end	
end

MakeDialog
{
	name = "endlessdifficult",
	Bitmap
	{
		image="images/ui/common/popup02",
		x		= kPopUpGeneralX,
		y		= kPopUpGeneralY,
		
		Text
		{
			font	= PopupFont,
			name	= "selectDificult",
			x		= 0,
			y		= kTitleY,
			w		= kMax,
			h		= 30,
			flags	= kHAlignCenter + kVAlignTop,
			label	= "selectDificult"	
		};
		
		SetStyle(FitnessButtonStyleTittleSmallBlue),
--Easy
		SBButton
		{
			x			= kCenter-kButtonSpaceX,
			y			= kFirstButtonY,
			name		= "easy",

			
			icon		= "assets/images/ui/buttons/icon/iconeasy",
			command =
				function()
					SetDifficultyLevel(0);
					SetCurrentGameMode(4);
					PopModal("endlessdifficult");
					-- Assuming rhe meta map is loaded
					PlayButton();
				end
		};
		Text
		{
			font		= SmallFont,
			x			= kCenter-kButtonSpaceX,
			y			= kFirstButtonY+kTextButton,
			flags		= kHAlignCenter + kVAlignCenter,
			label		= "easy",
		};
--Medium
		SBButton
		{
			x			= kCenter,
			y			= kFirstButtonY,
			name		= "medium",
			
			icon		= "assets/images/ui/buttons/icon/iconmedium",
			command =
				function()
					SetDifficultyLevel(1);
					SetCurrentGameMode(5);
					PopModal("endlessdifficult");
					-- Assuming rhe meta map is loaded
					PlayButton();
				end
		};
		Text
		{
			font		= SmallFont,
			x			= kCenter,
			y			= kFirstButtonY+kTextButton,
			flags		= kHAlignCenter + kVAlignCenter,
			label		= "medium",
		};
--Hard
		SBButton
		{
			x			= kCenter+kButtonSpaceX,
			y			= kFirstButtonY,
			name		= "hard",
			
			icon		= "assets/images/ui/buttons/icon/iconhard",
			command =
				function()
					SetDifficultyLevel(2);
					SetCurrentGameMode(6);
					PopModal("endlessdifficult");
					-- Assuming rhe meta map is loaded
					PlayButton();


				end
		};
		Text
		{
			font		= SmallFont,
			x			= kCenter+kButtonSpaceX,
			y			= kFirstButtonY+kTextButton,
			flags		= kHAlignCenter + kVAlignCenter,
			label		= "hard",
		};
--BACK
		SBButton{
			x=kCenter,
			y=kFirstButtonY + kButtonSpaceX,
			name="back",
			
			icon="assets/images/ui/buttons/icon/iconback",
			command = 
				function()
					PopModal("endlessdifficult");
				end
		};
		Text
		{
			font		= SmallFont,
			x			= kCenter,
			y			= kFirstButtonY+kTextButton+kButtonSpaceX,
			flags		= kHAlignCenter + kVAlignCenter,
			label="common.back.label",
		};
	},
}